<?php
namespace App\Controller;


use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Mailer\Email;
use SendGrid;

class EstadisticoController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        // Allow users to register and logout.
        // You should not add the "login" action to allow list. Doing so would
        // cause problems with normal functioning of AuthComponent.
        //$this->Auth->allow(['add', 'logout','resetPassword']);
    }

    public function reportes()
    {
        $active = 'reportes';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));

        $idCat=2;
        $idSubcat=1;

        $videosPopulares=$this->Estadistico->getPopularVideos();
        $this->set("videosPopulares",$videosPopulares);
        $videosPopularesBySubcat=$this->Estadistico->getPopularVideosBySubcat($idSubcat);
        
        $this->set("videosPopularesBySubcat",$videosPopularesBySubcat);
        $videosPopularesByCat=$this->Estadistico->getPopularVideosByCat($idCat);
        $this->set("videosPopularesByCat",$videosPopularesByCat);
        
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all")->select(["id","descripcion"])->where(["estatus"=>1]);
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT));
        $this->set("categorias",$categorias);
        $this->loadModel("CatSubcategoria");
        $subcategorias=$this->CatSubcategoria->find("all")->select(["id","descripcion"])->where(["estatus"=>1]);
        $subcategorias=json_decode(json_encode($subcategorias,JSON_PRETTY_PRINT));
        $this->set("subcategorias",$subcategorias);

        $vistasPorCategoria=$this->Estadistico->getVistasPorCategoria($idCat);
        $this->set("vistasPorCategoria",$vistasPorCategoria);
        $vistasPorSubcategoria=$this->Estadistico->getVistasPorSubcategoria($idCat);
        $this->set("vistasPorSubcategoria",$vistasPorSubcategoria);

        $videosMaxLikes=$this->Estadistico->getMaxLikes();
        $this->set("videosMaxLikes",$videosMaxLikes);
        $videosMaxLikesBySubcat=$this->Estadistico->getMaxLikesBySubcat($idSubcat);
        $this->set("videosMaxLikesBySubcat",$videosMaxLikesBySubcat);
        $videosMaxLikesByCat=$this->Estadistico->getMaxLikesByCat($idCat);
        $this->set("videosMaxLikesByCat",$videosMaxLikesByCat);

        $videosMaxDislikes=$this->Estadistico->getMaxDislikes();
        $this->set("videosMaxDislikes",$videosMaxDislikes);
        $videosMaxDislikesBySubcat=$this->Estadistico->getMaxDislikesBySubcat($idSubcat);
        $this->set("videosMaxDislikesBySubcat",$videosMaxDislikesBySubcat);
        $videosMaxDislikesByCat=$this->Estadistico->getMaxDislikesByCat($idCat);
        $this->set("videosMaxDislikesByCat",$videosMaxDislikesByCat);
    }
    public function Generador()
    {
        $active = 'reportes';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));

        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all")->select(["id","descripcion"])->where(["estatus"=>1]);
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT));
        $this->set("categorias",$categorias);

        if(!empty($_POST))
        {
            $inicio=date("Y-m-d",strtotime($_POST["start"]));
            $fin=date("Y-m-d",strtotime($_POST["end"]));
            $finQuery=date("Y-m-d",strtotime($fin."+ 1 day"));
            $fechas=array();
            
            $timeIni=strtotime($inicio);
            $timeFin=strtotime($fin);
            while($timeIni<=$timeFin)
            {
                $fechaIN=date("Y-m-d",$timeIni);
                array_push($fechas, $fechaIN);
                $timeIni=strtotime($fechaIN."+ 1 day");
            }
            if(isset($_POST["option"]))
            {
                foreach ($_POST["option"] as $key => $value) {
                    
                    switch($value)
                    {
                        case 1:
                            //echo "Vistas";
                            if($_POST["cat"]!=0)
                            {
                                if($_POST["subcat"]!=0)
                                {
                                    $popularVideos=$this->Estadistico->getPopularVideosBySubcatDateLimit($_POST["subcat"],$inicio,$finQuery);
                                }
                                else
                                {
                                    $popularVideos=$this->Estadistico->getPopularVideosByCatDateLimit($_POST["cat"],$inicio,$finQuery);
                                }
                            }
                            else
                            {
                                $popularVideos=$this->Estadistico->getPopularVideosDateLimit($inicio,$finQuery);
                            }
                            $this->set("vistas",$popularVideos);
                            break;
                        case 2:
                            //echo "Likes";
                            if($_POST["cat"]!=0)
                            {
                                if($_POST["subcat"]!=0)
                                {
                                    $likesVideos=$this->Estadistico->TotalLikesSubcategoria(array($_POST["subcat"]));
                                    //$subcats=$this->Estadistico->getAllSubcategoriasFromCategoria($_POST["cat"]);
                                    
                                    $likesxSubCat=$this->Estadistico->TotalLikesCategoria(array($_POST["subcat"]));
                                    //$cats=$this->Estadistico->getAllCategorias();
                                    
                                    $likesxCat=$this->Estadistico->TotalLikes(array($_POST["cat"]));
                                }
                                else
                                {
                                    $subcats=$this->Estadistico->getAllSubcategoriasFromCategoria($_POST["cat"]);
                                    $subcatsArr=array();
                                    foreach ($subcats as $key => $value) {
                                        array_push($subcatsArr, $value["id"]);
                                    }
                                    $likesVideos=$this->Estadistico->TotalLikesSubcategoria($subcatsArr);
                                    $likesxSubCat=$this->Estadistico->TotalLikesCategoria($subcatsArr);
                                    $likesxCat=$this->Estadistico->TotalLikes(array($_POST["cat"]));
                                }
                            }
                            else
                            {
                                $subcats=$this->Estadistico->getAllSubcategorias();
                                $subcatsArr=array();
                                foreach ($subcats as $key => $value) {
                                    array_push($subcatsArr, $value["id"]);
                                }
                                $likesVideos=$this->Estadistico->TotalLikesSubcategoria($subcatsArr);
                                $likesxSubCat=$this->Estadistico->TotalLikesCategoria($subcatsArr);
                                $cats=$this->Estadistico->getAllCategorias();
                                $catsArr=array();
                                foreach ($cats as $key => $value) {
                                    array_push($catsArr, $value["id"]);
                                }
                                $likesxCat=$this->Estadistico->TotalLikes($catsArr);
                                
                            }
                            $this->set("likesVideos",$likesVideos);
                            $this->set("likesxSubCat",$likesxSubCat);
                            $this->set("likesxCat",$likesxCat);
                            break;
                        case 3:
                            //echo "Dislikes";
                            if($_POST["cat"]!=0)
                            {
                                if($_POST["subcat"]!=0)
                                {
                                    $dislikesVideos=$this->Estadistico->TotalDislikesSubcategoria(array($_POST["subcat"]));
                                    //$subcats=$this->Estadistico->getAllSubcategoriasFromCategoria($_POST["cat"]);
                                    
                                    $dislikesxSubCat=$this->Estadistico->TotalDislikesCategoria(array($_POST["subcat"]));
                                    //$cats=$this->Estadistico->getAllCategorias();
                                    
                                    $dislikesxCat=$this->Estadistico->TotalDislikes(array($_POST["cat"]));
                                }
                                else
                                {
                                    $subcats=$this->Estadistico->getAllSubcategoriasFromCategoria($_POST["cat"]);
                                    $subcatsArr=array();
                                    foreach ($subcats as $key => $value) {
                                        array_push($subcatsArr, $value["id"]);
                                    }
                                    $dislikesVideos=$this->Estadistico->TotalDislikesSubcategoria($subcatsArr);
                                    $dislikesxSubCat=$this->Estadistico->TotalDislikesCategoria($subcatsArr);
                                    $dislikesxCat=$this->Estadistico->TotalDislikes(array($_POST["cat"]));
                                }
                            }
                            else
                            {
                                $subcats=$this->Estadistico->getAllSubcategorias();
                                $subcatsArr=array();
                                foreach ($subcats as $key => $value) {
                                    array_push($subcatsArr, $value["id"]);
                                }
                                $dislikesVideos=$this->Estadistico->TotalDislikesSubcategoria($subcatsArr);
                                $dislikesxSubCat=$this->Estadistico->TotalDislikesCategoria($subcatsArr);
                                $cats=$this->Estadistico->getAllCategorias();
                                $catsArr=array();
                                foreach ($cats as $key => $value) {
                                    array_push($catsArr, $value["id"]);
                                }
                                $dislikesxCat=$this->Estadistico->TotalDislikes($catsArr);
                                
                            }
                            $this->set("dislikesVideos",$dislikesVideos);
                            $this->set("dislikesxSubCat",$dislikesxSubCat);
                            $this->set("dislikesxCat",$dislikesxCat);
                            break;
                        case 4:
                            //echo "Visitas";
                            if($_POST["cat"]!=0)
                            {
                                $mainVisitas=array();
                                if($_POST["subcat"]!=0)
                                {
                                    $videos=$this->Estadistico->getAllVideosFromSubcategoria($_POST["subcat"]);
                                    $videosArr=array();
                                    foreach ($videos as $key => $value) {
                                        array_push($videosArr, $value["id_video"]);
                                    }
                                    $visitasVideo=$this->Estadistico->getVisitasByVideo($inicio,$finQuery,$videosArr);
                                    $visitasSubcat=$this->Estadistico->getVisitasBySubategory($inicio,$finQuery,array($_POST["subcat"]));
                                    $visitasCat=$this->Estadistico->getVisitasByCategory($inicio,$finQuery,array($_POST["cat"]));
                                }
                                else
                                {
                                    $videos=$this->Estadistico->getAllVideosFromCategoria($_POST["cat"]);
                                    $videosArr=array();
                                    foreach ($videos as $key => $value) {
                                        array_push($videosArr, $value["id_video"]);
                                    }
                                    $visitasVideo=$this->Estadistico->getVisitasByVideo($inicio,$finQuery,$videosArr);
                                    $subcats=$this->Estadistico->getAllSubcategoriasFromCategoria($_POST["cat"]);
                                    $subcatsArr=array();
                                    foreach ($subcats as $key => $value) {
                                        array_push($subcatsArr, $value["id"]);
                                    }
                                    $visitasSubcat=$this->Estadistico->getVisitasBySubategory($inicio,$finQuery,$subcatsArr);
                                    $visitasCat=$this->Estadistico->getVisitasByCategory($inicio,$finQuery,array($_POST["cat"]));
                                }
                            }
                            else
                            {
                                $videos=$this->Estadistico->getAllVideos();
                                $videosArr=array();
                                foreach ($videos as $key => $value) {
                                    array_push($videosArr, $value["id"]);
                                }
                                $visitasVideo=$this->Estadistico->getVisitasByVideo($inicio,$finQuery,$videosArr);
                                $subcats=$this->Estadistico->getAllSubcategorias();
                                $subcatsArr=array();
                                foreach ($subcats as $key => $value) {
                                    array_push($subcatsArr, $value["id"]);
                                }
                                $visitasSubcat=$this->Estadistico->getVisitasBySubategory($inicio,$finQuery,$subcatsArr);
                                $cats=$this->Estadistico->getAllCategorias();
                                $catsArr=array();
                                foreach ($cats as $key => $value) {
                                    array_push($catsArr, $value["id"]);
                                }
                                $visitasCat=$this->Estadistico->getVisitasByCategory($inicio,$finQuery,$catsArr);
                                $mainVisitas=$this->Estadistico->getVisitasMain($inicio,$finQuery);
                            }
                            $visitasArray=array();
                            foreach ($fechas as $key => $value) {
                                $visitasArray[$value]=0;
                                foreach ($visitasVideo as $key2 => $value2) {
                                    if(date("Y-m-d",strtotime($value2["hora"]))==$value)
                                    {
                                        $visitasArray[$value]+=$value2["cuantos"];
                                    }
                                }
                                foreach ($visitasSubcat as $key2 => $value2) {
                                    if(date("Y-m-d",strtotime($value2["hora"]))==$value)
                                    {
                                        $visitasArray[$value]+=$value2["cuantos"];
                                    }
                                }
                                foreach ($visitasCat as $key2 => $value2) {
                                    if(date("Y-m-d",strtotime($value2["hora"]))==$value)
                                    {
                                        $visitasArray[$value]+=$value2["cuantos"];
                                    }
                                }
                                foreach ($mainVisitas as $key2 => $value2) {
                                    if(date("Y-m-d",strtotime($value2["hora"]))==$value)
                                    {
                                        $visitasArray[$value]+=$value2["cuantos"];
                                    }
                                }
                            }
                            $this->set("visitas",$visitasArray);
                            break;
                            
                        default:

                            break;
                    }
                }
            }
            $this->set("inicio",$inicio);
            $this->set("fin",$fin);
            //print_r($fechas);
        }
    }
    public function getSubcatsByCat($idCat)
    {
        $this->autoRender=false;
        $this->loadModel("CatSubcategoria");
        $subcategorias=$this->CatSubcategoria->find("all")->select(["id","descripcion"])->where(["id_categoria"=>$idCat]);
        $subcategorias=json_decode(json_encode($subcategorias,JSON_PRETTY_PRINT));
        echo "<option value='0'>Selecciona una opci&oacute;n</option>";
        foreach ($subcategorias as $key => $value) {
            echo "<option value=".$value->id.">".$value->descripcion."</option>";
        }
    }

    public function verTodosPopulares($tipo=1,$idSearch=null)
    {
        $active = 'reportes';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));

        switch ($tipo) {
            case 1:
                $videosPopulares=$this->Estadistico->getPopularVideosDateLimit();
                $tipo="Plataforma";
                $filtro="";
                break;
            case 2:
                $videosPopulares=$this->Estadistico->getPopularVideosByCatNoLimit($idSearch);
                $this->loadModel("CatCategoria");
                $cat=$this->CatCategoria->get($idSearch);
                $tipo="categor&iacute;a";
                $filtro=$cat->descripcion;
                break;
            case 3:
                $videosPopulares=$this->Estadistico->getPopularVideosBySubcatNoLimit($idSearch);
                $this->loadModel("CatSubcategoria");
                $subcat=$this->CatSubcategoria->get($idSearch);
                $filtro=$subcat->descripcion;
                $tipo="subcategor&iacute;a";

                break;
            default:
                $videosPopulares=$this->Estadistico->getPopularVideosNoLimit();
                $tipo="Plataforma";
                $filtro="";
                break;
        }
        $this->set("videosPopulares",$videosPopulares);
        $this->set("tipo",$tipo);
        $this->set("filtro",$filtro);
    }

        public function verTodosFavoritos($tipo=1,$idSearch=null)
    {
        $active = 'reportes';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));

        switch ($tipo) {
            case 1:
                $videosFavoritos=$this->Estadistico->getMaxLikesNoLimit();
                $tipo="Plataforma";
                $filtro="";
                break;
            case 2:
                $videosFavoritos=$this->Estadistico->getMaxLikesByCatNoLimit($idSearch);
                $this->loadModel("CatCategoria");
                $cat=$this->CatCategoria->get($idSearch);
                $tipo="categor&iacute;a";
                $filtro=$cat->descripcion;
                break;
            case 3:
                $videosFavoritos=$this->Estadistico->getMaxLikesBySubcatNoLimit($idSearch);
                $this->loadModel("CatSubcategoria");
                $subcat=$this->CatSubcategoria->get($idSearch);
                $filtro=$subcat->descripcion;
                $tipo="subcategor&iacute;a";

                break;
            default:
                $videosFavoritos=$this->Estadistico->getMaxLikesNoLimit();
                $tipo="Plataforma";
                $filtro="";
                break;
        }
        $this->set("videosFavoritos",$videosFavoritos);
        $this->set("tipo",$tipo);
        $this->set("filtro",$filtro);
    }

        public function verTodosOdiados($tipo=1,$idSearch=null)
    {
        $active = 'reportes';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));

        switch ($tipo) {
            case 1:
                $videosOdiados=$this->Estadistico->getMaxDislikesNoLimit();
                $tipo="Plataforma";
                $filtro="";
                break;
            case 2:
                $videosOdiados=$this->Estadistico->getMaxDislikesByCatNoLimit($idSearch);
                $this->loadModel("CatCategoria");
                $cat=$this->CatCategoria->get($idSearch);
                $tipo="categor&iacute;a";
                $filtro=$cat->descripcion;
                break;
            case 3:
                $videosOdiados=$this->Estadistico->getMaxDislikesBySubcatNoLimit($idSearch);
                $this->loadModel("CatSubcategoria");
                $subcat=$this->CatSubcategoria->get($idSearch);
                $filtro=$subcat->descripcion;
                $tipo="subcategor&iacute;a";

                break;
            default:
                $videosOdiados=$this->Estadistico->getMaxDislikesNoLimit();
                $tipo="Plataforma";
                $filtro="";
                break;
        }
        $this->set("videosOdiados",$videosOdiados);
        $this->set("tipo",$tipo);
        $this->set("filtro",$filtro);
    }


    public function getPopularidadPorCat($idCat)
    {
        $this->autoRender=false;
        $videosPopularesByCat=$this->Estadistico->getPopularVideosByCat($idCat);
        foreach ($videosPopularesByCat as $key => $value) {
            echo "<tr class='text-center'>
                    <td style='vertical-align:middle; font-size: 25px;'>".($key+1)."</td>
                    <td style='vertical-align:middle;'><img src='".str_replace('mqdefault', 'default', $value['imagen'])."'></td>
                    <td style='vertical-align:middle;'>".$value['id_video']."</td>
                    <td style='vertical-align:middle;' align='left'><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value['cat']))."/".urlencode($this->normaliza($value['subcat']))."/".urlencode($this->normaliza($value['nombre']))."-".urlencode($this->normaliza($value['id_video']))."-".str_replace('-', '_guion_', $value['youtube_id'])."'>".$value['nombre']."</a></td>
                    <td style='vertical-align:middle;'><img src='http://senseytv.webfactory.mx/img/categorias/cate_".$value['id_cat'].".png'</td>
                    <td style='vertical-align:middle;'><img src='http://senseytv.webfactory.mx/img/categorias/subcat_".$value['id_subcat'].".png'</td>
                    <td style='vertical-align:middle;'>".$value['sitio']."</td>
                    <td style='vertical-align:middle;'>".round($value['pct'],2)."%</td>
                    <td style='vertical-align:middle;'>".$value['youtube']."</td>
                    <td style='vertical-align:middle;'>".$value['likes_no']."</td>
                    <td style='vertical-align:middle;'>".$value['dislike']."</td>
                </tr>";

        }
        echo "<tr>
                <td colspan='11'><button class='pull-right btn btn-info' onclick='window.location.href=\"/Estadistico/verTodosPopulares/2/".$idCat."\"'><i class='fa fa-search'></i>Ver todos</button></td>
            </tr>";;
    }
    public function getPopularidadPorSubcat($idSubcat)
    {
        $this->autoRender=false;
        $videosPopularesBySubcat=$this->Estadistico->getPopularVideosBySubcat($idSubcat);
        foreach ($videosPopularesBySubcat as $key => $value) {
            echo "<tr class='text-center'>
                    <td style='vertical-align:middle; font-size: 25px;'>".($key+1)."</td>
                    <td style='vertical-align:middle;'><img src='".str_replace('mqdefault', 'default', $value['imagen'])."'></td>
                    <td style='vertical-align:middle;'>".$value['id_video']."</td>
                    <td style='vertical-align:middle;' align='left'><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value['cat']))."/".urlencode($this->normaliza($value['subcat']))."/".urlencode($this->normaliza($value['nombre']))."-".urlencode($this->normaliza($value['id_video']))."-".str_replace('-', '_guion_', $value['youtube_id'])."'>".$value['nombre']."</a></td>
                    <td style='vertical-align:middle;'><img src='http://senseytv.webfactory.mx/img/categorias/cate_".$value['id_cat'].".png'</td>
                    <td style='vertical-align:middle;'><img src='http://senseytv.webfactory.mx/img/categorias/subcat_".$value['id_subcat'].".png'</td>
                    <td style='vertical-align:middle;'>".$value['sitio']."</td>
                    <td style='vertical-align:middle;'>".round($value['pct'],2)."%</td>
                    <td style='vertical-align:middle;'>".$value['youtube']."</td>
                    <td style='vertical-align:middle;'>".$value['likes_no']."</td>
                    <td style='vertical-align:middle;'>".$value['dislike']."</td>
                </tr>";

        }
        echo "<tr>
                <td colspan='11'><button class='pull-right btn btn-info' onclick='window.location.href=\"/Estadistico/verTodosPopulares/3/".$idSubcat."\"'><i class='fa fa-search'></i>Ver todos</button></td>
            </tr>";
    }
    public function getLikesPorCat($idCat)
    {
        $this->autoRender=false;
        $videosMaxLikesByCat=$this->Estadistico->getMaxLikesByCat($idCat);
        foreach ($videosMaxLikesByCat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["likes_no"]."</td>
                </tr>";
        }
        echo "<tr>
                <td colspan='5'><button class='pull-right btn btn-info' onclick='window.location.href=\"/Estadistico/verTodosFavoritos/2/".$idCat."\"'><i class='fa fa-search'></i>Ver todos</button></td>
            </tr>";
    }
    public function getLikesPorSubcat($idSubcat)
    {
        $this->autoRender=false;
        $videosMaxLikesBySubcat=$this->Estadistico->getMaxLikesBySubcat($idSubcat);
        foreach ($videosMaxLikesBySubcat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["likes_no"]."</td>
                </tr>";
       }
        echo "<tr>
                <td colspan='5'><button class='pull-right btn btn-info' onclick='window.location.href=\"/Estadistico/verTodosFavoritos/3/".$idSubcat."\"'><i class='fa fa-search'></i>Ver todos</button></td>
            </tr>";
    }
    public function getDislikesPorCat($idCat)
    {
        $this->autoRender=false;
        $videosMaxDislikesByCat=$this->Estadistico->getMaxDislikesByCat($idCat);
        foreach ($videosMaxDislikesByCat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["dislike"]."</td>
                </tr>";
        }
        echo "<tr>
                <td colspan='5'><button class='pull-right btn btn-info' onclick='window.location.href=\"/Estadistico/verTodosOdiados/2/".$idCat."\"'><i class='fa fa-search'></i>Ver todos</button></td>
            </tr>";
    }
    public function getDislikesPorSubcat($idSubcat)
    {
        $this->autoRender=false;
        $videosMaxDislikesBySubcat=$this->Estadistico->getMaxDislikesBySubcat($idSubcat);
        foreach ($videosMaxDislikesBySubcat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["dislike"]."</td>
                </tr>";
        }
        echo "<tr>
                <td colspan='5'><button class='pull-right btn btn-info' onclick='window.location.href=\"/Estadistico/verTodosOdiados/3/".$idSubcat."\"'><i class='fa fa-search'></i>Ver todos</button></td>
            </tr>";
    }
    function normaliza ($cadena){
        $originales = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ?¿';
        $modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr  ';
        $cadena = utf8_decode($cadena);
        $cadena = strtr($cadena, utf8_decode($originales), $modificadas);
        //$cadena = strtolower($cadena);
        return utf8_encode($cadena);
    }

    public function correo()
    {
        $active = 'reportes';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));

        $idCat=2;
        $idSubcat=1;

        $videosPopulares=$this->Estadistico->getPopularVideos();
        $this->set("videosPopulares",$videosPopulares);
        $videosPopularesBySubcat=$this->Estadistico->getPopularVideosBySubcat($idSubcat);
        $this->set("videosPopularesBySubcat",$videosPopularesBySubcat);
        $videosPopularesByCat=$this->Estadistico->getPopularVideosByCat($idCat);
        exit;
        $this->set("videosPopularesByCat",$videosPopularesByCat);
        
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all")->select(["id","descripcion"])->where(["estatus"=>1]);
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT));
        $this->set("categorias",$categorias);
        $this->loadModel("CatSubcategoria");
        $subcategorias=$this->CatSubcategoria->find("all")->select(["id","descripcion"])->where(["estatus"=>1]);
        $subcategorias=json_decode(json_encode($subcategorias,JSON_PRETTY_PRINT));
        $this->set("subcategorias",$subcategorias);

        $vistasPorCategoria=$this->Estadistico->getVistasPorCategoria($idCat);
        $this->set("vistasPorCategoria",$vistasPorCategoria);
        $vistasPorSubcategoria=$this->Estadistico->getVistasPorSubcategoria($idCat);
        $this->set("vistasPorSubcategoria",$vistasPorSubcategoria);

        $videosMaxLikes=$this->Estadistico->getMaxLikes();
        $this->set("videosMaxLikes",$videosMaxLikes);
        $videosMaxLikesBySubcat=$this->Estadistico->getMaxLikesBySubcat($idSubcat);
        $this->set("videosMaxLikesBySubcat",$videosMaxLikesBySubcat);
        $videosMaxLikesByCat=$this->Estadistico->getMaxLikesByCat($idCat);
        $this->set("videosMaxLikesByCat",$videosMaxLikesByCat);

        $videosMaxDislikes=$this->Estadistico->getMaxDislikes();
        $this->set("videosMaxDislikes",$videosMaxDislikes);
        $videosMaxDislikesBySubcat=$this->Estadistico->getMaxDislikesBySubcat($idSubcat);
        $this->set("videosMaxDislikesBySubcat",$videosMaxDislikesBySubcat);
        $videosMaxDislikesByCat=$this->Estadistico->getMaxDislikesByCat($idCat);
        $this->set("videosMaxDislikesByCat",$videosMaxDislikesByCat);
    }
}