<?php
namespace App\Controller;


use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Mailer\Email;
use SendGrid;

class GeneradorRepController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        // Allow users to register and logout.
        // You should not add the "login" action to allow list. Doing so would
        // cause problems with normal functioning of AuthComponent.
        //$this->Auth->allow(['add', 'logout','resetPassword']);
    }

    public function reportes()
    {
        $active = 'reportes';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));

        $idCat=2;
        $idSubcat=1;

        $videosPopulares=$this->Estadistico->getPopularVideos();
        $this->set("videosPopulares",$videosPopulares);
        $videosPopularesBySubcat=$this->Estadistico->getPopularVideosBySubcat($idSubcat);
        $this->set("videosPopularesBySubcat",$videosPopularesBySubcat);
        $videosPopularesByCat=$this->Estadistico->getPopularVideosByCat($idCat);
        $this->set("videosPopularesByCat",$videosPopularesByCat);
        
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all")->select(["id","descripcion"])->where(["estatus"=>1]);
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT));
        $this->set("categorias",$categorias);
        $this->loadModel("CatSubcategoria");
        $subcategorias=$this->CatSubcategoria->find("all")->select(["id","descripcion"])->where(["estatus"=>1]);
        $subcategorias=json_decode(json_encode($subcategorias,JSON_PRETTY_PRINT));
        $this->set("subcategorias",$subcategorias);

        $vistasPorCategoria=$this->Estadistico->getVistasPorCategoria($idCat);
        $this->set("vistasPorCategoria",$vistasPorCategoria);
        $vistasPorSubcategoria=$this->Estadistico->getVistasPorSubcategoria($idCat);
        $this->set("vistasPorSubcategoria",$vistasPorSubcategoria);

        $videosMaxLikes=$this->Estadistico->getMaxLikes();
        $this->set("videosMaxLikes",$videosMaxLikes);
        $videosMaxLikesBySubcat=$this->Estadistico->getMaxLikesBySubcat($idSubcat);
        $this->set("videosMaxLikesBySubcat",$videosMaxLikesBySubcat);
        $videosMaxLikesByCat=$this->Estadistico->getMaxLikesByCat($idCat);
        $this->set("videosMaxLikesByCat",$videosMaxLikesByCat);

        $videosMaxDislikes=$this->Estadistico->getMaxDislikes();
        $this->set("videosMaxDislikes",$videosMaxDislikes);
        $videosMaxDislikesBySubcat=$this->Estadistico->getMaxDislikesBySubcat($idSubcat);
        $this->set("videosMaxDislikesBySubcat",$videosMaxDislikesBySubcat);
        $videosMaxDislikesByCat=$this->Estadistico->getMaxDislikesByCat($idCat);
        $this->set("videosMaxDislikesByCat",$videosMaxDislikesByCat);
    }
    public function getPopularidadPorCat($idCat)
    {
        $this->autoRender=false;
        $videosPopularesByCat=$this->Estadistico->getPopularVideosByCat($idCat);
        foreach ($videosPopularesByCat as $key => $value) {
            echo "<tr>
                <td>".$value["id_video"]."</td>
                <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id_video"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                <td>".$value["sitio"]."</td>
                <td>".round($value["pct"],2)."%</td>
                <td>".$value["youtube"]."</td>
            </tr>";
        }
    }
    public function getPopularidadPorSubcat($idSubcat)
    {
        $this->autoRender=false;
        $videosPopularesBySubcat=$this->Estadistico->getPopularVideosBySubcat($idSubcat);
        foreach ($videosPopularesBySubcat as $key => $value) {
            echo "<tr>
                <td>".$value["id_video"]."</td>
                <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id_video"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                <td>".$value["sitio"]."</td>
                <td>".round($value["pct"],2)."%</td>
                <td>".$value["youtube"]."</td>
                
            </tr>";
        }
    }
    public function getLikesPorCat($idCat)
    {
        $this->autoRender=false;
        $videosMaxLikesByCat=$this->Estadistico->getMaxLikesByCat($idCat);
        foreach ($videosMaxLikesByCat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["likes_no"]."</td>
                </tr>";
        }
    }
    public function getLikesPorSubcat($idSubcat)
    {
        $this->autoRender=false;
        $videosMaxLikesBySubcat=$this->Estadistico->getMaxLikesBySubcat($idSubcat);
        foreach ($videosMaxLikesBySubcat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["likes_no"]."</td>
                </tr>";
        }
    }
    public function getDislikesPorCat($idCat)
    {
        $this->autoRender=false;
        $videosMaxDislikesByCat=$this->Estadistico->getMaxDislikesByCat($idCat);
        foreach ($videosMaxDislikesByCat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["dislike"]."</td>
                </tr>";
        }
    }
    public function getDislikesPorSubcat($idSubcat)
    {
        $this->autoRender=false;
        $videosMaxDislikesBySubcat=$this->Estadistico->getMaxDislikesBySubcat($idSubcat);
        foreach ($videosMaxDislikesBySubcat as $key => $value) {
            echo "<tr>
                    <td>".$value["id"]."</td>
                    <td><a target='_blank' href='http://senseytv.webfactory.mx/".urlencode($this->normaliza($value["cat"]))."/".urlencode($this->normaliza($value["subcat"]))."/".urlencode($this->normaliza($value["nombre"]))."-".urlencode($this->normaliza($value["id"]))."-".str_replace("-", "_guion_", $value['youtube_id'])."'>".$value["nombre"]."</a></td>
                    <td>".$value["dislike"]."</td>
                </tr>";
        }
    }
    function normaliza ($cadena){
        $originales = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ?¿';
        $modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr  ';
        $cadena = utf8_decode($cadena);
        $cadena = strtr($cadena, utf8_decode($originales), $modificadas);
        //$cadena = strtolower($cadena);
        return utf8_encode($cadena);
    }
}