<?php
namespace App\Controller;

require_once(ROOT . DS . 'vendor' . DS . "sendgrid" . DS . "sendgrid-php" . DS . "sendgrid-php.php");
require_once(ROOT . DS . 'webroot' . DS . "php" . DS . "google-api-php-client-master" . DS . "src" . DS . "Google" . DS . "Client.php");
require_once(ROOT . DS . 'webroot' . DS . "php" . DS . "google-api-php-client" . DS . "vendor" . DS . "autoload.php");
require_once(ROOT . DS . 'webroot' . DS . "php" . DS . "google-api-php-client-master" . DS . "src" . DS . "Google" . DS . "Service" . DS . "YouTube.php");
use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Mailer\Email;
use SendGrid;
use Google_Client;
use Google_Service_YouTube;

class PrincipalController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        // Allow users to register and logout.
        // You should not add the "login" action to allow list. Doing so would
        // cause problems with normal functioning of AuthComponent.
        //$this->Auth->allow(['add', 'logout','resetPassword']);
    }

    public function index()
    {
        $active = 'principal';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description','Dashboard');
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
        $videosPorCat=$this->Principal->getVideosPorCategoria();
        $this->set("videosPorCat",$videosPorCat);

        $inicio=date("Y-m-d",strtotime("- 7 day"));
        $fin=date("Y-m-d");
        $fechas=array();
        
        $timeIni=strtotime($inicio);
        $timeFin=strtotime($fin);
        while($timeIni<=$timeFin)
        {
            $fechaINTO=date("M d",$timeIni);
            $fechaIN=date("Y-m-d",$timeIni);
            array_push($fechas, $fechaINTO);
            $timeIni=strtotime($fechaIN."+ 1 day");
        }
        $finConsulta=date("Y-m-d",strtotime($fin."+ 1 day"));
        $this->loadModel("Estadistico");
        $mainVisitas=$this->Estadistico->getVisitasMain($inicio,$finConsulta);

        $videos=$this->Estadistico->getAllVideos();
        $videosArr=array();
        foreach ($videos as $key => $value) {
            array_push($videosArr, $value["id"]);
        }
        $visitasVideo=$this->Estadistico->getVisitasByVideo($inicio,$finConsulta,$videosArr);
        $subcats=$this->Estadistico->getAllSubcategorias();
        $subcatsArr=array();
        foreach ($subcats as $key => $value) {
            array_push($subcatsArr, $value["id"]);
        }
        $visitasSubcat=$this->Estadistico->getVisitasBySubategory($inicio,$finConsulta,$subcatsArr);
        $cats=$this->Estadistico->getAllCategorias();
        $catsArr=array();
        foreach ($cats as $key => $value) {
            array_push($catsArr, $value["id"]);
        }
        $visitasCat=$this->Estadistico->getVisitasByCategory($inicio,$finConsulta,$catsArr);
        $visitasArray=array();
        $mesEsp=array("Ene","Abr","Ago");
        $mesIng=array("Jan","Apr","Aug");
        foreach ($fechas as $key => $value) {
            $diaEsp=str_replace($mesIng, $mesEsp, $value);
            $visitasArray[$diaEsp]=0;
            foreach ($mainVisitas as $key2 => $value2) {
                if(str_replace($mesIng, $mesEsp, date("M d",strtotime($value2["hora"])))==$diaEsp)
                {
                    $visitasArray[$diaEsp]+=$value2["cuantos"];
                }
            }
            foreach ($visitasVideo as $key2 => $value2) {
                if(str_replace($mesIng, $mesEsp, date("M d",strtotime($value2["hora"])))==$diaEsp)
                {
                    $visitasArray[$diaEsp]+=$value2["cuantos"];
                }
            }
            foreach ($visitasSubcat as $key2 => $value2) {
                if(str_replace($mesIng, $mesEsp, date("M d",strtotime($value2["hora"])))==$diaEsp)
                {
                    $visitasArray[$diaEsp]+=$value2["cuantos"];
                }
            }
            foreach ($visitasCat as $key2 => $value2) {
                if(str_replace($mesIng, $mesEsp, date("M d",strtotime($value2["hora"])))==$diaEsp)
                {
                    $visitasArray[$diaEsp]+=$value2["cuantos"];
                }
            }
        }
        $this->set("visitas",$visitasArray);
    }
    function getDatavideo($videoId)
    {
        $this->autoRender=false;
        $DEVELOPER_KEY = 'AIzaSyBAQyXCnEjp_viNuJ_L6ZQ5lGr9_1NMCOI';
  
        $client = new Google_Client();  
        $client->setDeveloperKey($DEVELOPER_KEY); 
        $youtube = new Google_Service_YouTube($client);
        $listResponse = $youtube->videos->listVideos("snippet",
        array('id' => $videoId));
        $listResponse2 = $youtube->videos->listVideos("statistics",
        array('id' => $videoId));
        $snippet=json_decode(json_encode($listResponse->toSimpleObject()),true);
        $statistics=json_decode(json_encode($listResponse2->toSimpleObject()),true);
        if (empty($snippet["items"])) {
            $error=array("error"=>"Video no Encontrado");
            return json_encode($error);
        }
        else
        {
            $datavideo=array("general"=>$snippet["items"][0]["snippet"],"estadisticas"=>$statistics["items"][0]["statistics"]);

            return json_encode($datavideo);
        }
    }
    public function getAllVideos()
    {
        $this->autoRender=false;
        $this->loadModel("Video");
        $videos=$this->Video->find("all")->select(["id","youtube_id"]);
        $videos=json_decode(json_encode($videos,JSON_PRETTY_PRINT),true);
        echo json_encode($videos);
    }
    public function sincronizarVideos($id,$idYoutube)
    {
        //ini_set('max_execution_time', 0);
        $this->autoRender=false;
        $this->loadModel("Video");
        $jsonVideo=$this->getDatavideo($idYoutube);
    
        $arrVideo=json_decode($jsonVideo,true);
        //print_r($arrVideo);
        $vidEdited=$this->Video->newEntity();
        $vidEdited=$this->Video->get($id);
        $vidEdited->dislike=$arrVideo["estadisticas"]["dislikeCount"];
        $vidEdited->likes_no=$arrVideo["estadisticas"]["likeCount"];
        $vidEdited->views_no=$arrVideo["estadisticas"]["viewCount"];
        $this->Video->save($vidEdited);

    }

}