<?php
namespace App\Controller;

require_once(ROOT . DS . 'vendor' . DS . "sendgrid" . DS . "sendgrid-php" . DS . "sendgrid-php.php");
require_once(ROOT . DS . 'webroot' . DS . "php" . DS . "google-api-php-client-master" . DS . "src" . DS . "Google" . DS . "Client.php");
require_once(ROOT . DS . 'webroot' . DS . "php" . DS . "google-api-php-client" . DS . "vendor" . DS . "autoload.php");
require_once(ROOT . DS . 'webroot' . DS . "php" . DS . "google-api-php-client-master" . DS . "src" . DS . "Google" . DS . "Service" . DS . "YouTube.php");
use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Mailer\Email;
use SendGrid;
use Google_Client;
use Google_Service_YouTube;

class PublicacionController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        // Allow users to register and logout.
        // You should not add the "login" action to allow list. Doing so would
        // cause problems with normal functioning of AuthComponent.
        $this->Auth->allow(['getDatavideo']);
    }

    public function index()
    {
        $active = 'publicacion';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Publicaciones");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all");
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT),true);
        $this->set("categorias",$categorias);
    }
    public function eliminados()
    {
        $active = 'eliminados';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Publicaciones");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all");
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT),true);
        $this->set("categorias",$categorias);
    }
    public function getVideos($view){
        if($view==1)
        {
            $status=array(1,2);
            if(!empty($_POST))
            {
                if(isset($_POST["estatus"]))
                {
                    if(!empty($_POST["estatus"]))
                    {
                        $status=$_POST["estatus"];
                    }
                }
            }
        }
        else
        {
            $status=array(3);
        }
        $this->autoRender=false;
        $this->loadModel("Video");
        if(empty($_POST))
        {
        
            $videos=$this->Video->find("all")->contain(["CrossVideoSubcategoria","CrossVideoSubcategoria.CatSubcategoria","CrossVideoSubcategoria.CatSubcategoria.CatCategoria",
                "CrossVideoSerie","CrossVideoSerie.CatSerie","CatEstatusVideo"])->where(["Video.id_estatus IN"=>$status]);
        }
        else
        {
            if(empty($_POST["categorias"]))
            {
                $videos=$this->Video->find("all")->contain(["CrossVideoSubcategoria","CrossVideoSubcategoria.CatSubcategoria","CrossVideoSubcategoria.CatSubcategoria.CatCategoria",
                "CrossVideoSerie","CrossVideoSerie.CatSerie","CatEstatusVideo"])->where(["Video.id_estatus IN"=>$status]);
            }
            else
            {
                $cats=$_POST["categorias"];
                $videos=$this->Video->find("all")->contain(["CrossVideoSubcategoria"=>function($q) use ($cats){
                    $this->loadModel("CatSubcategoria");
                    $subcats=$this->CatSubcategoria->find("all")->select(["id"])->where(["id_categoria IN"=>$cats]);
                    //debug($subcats);
                    return $q->where(["id_subcategoria IN"=>$subcats]);
                },"CrossVideoSubcategoria.CatSubcategoria","CrossVideoSubcategoria.CatSubcategoria.CatCategoria",
                "CrossVideoSerie","CrossVideoSerie.CatSerie","CatEstatusVideo"])->where(["Video.id_estatus IN"=>$status]);
            }
        }
        $videos=json_decode(json_encode($videos,JSON_PRETTY_PRINT),true);
        $data=array();
        foreach ($videos as $key => $value) {
            if(!empty($value["cross_video_subcategoria"]))
            {
                $share="";
                if($value['id_estatus']!=1)
                {
                    $share="disabled";
                }
                $disable="";
                $iconEstatus="fa-times-circle";
                $tooltipEstatus="Eliminar video";
                $descativarTitle="Desactivar";
                $editVideoText="<li>
                                <span class='btn btn-default tip' data-original-title='Editar video' style='cursor:pointer;' data-video='".$value["id"]."' onclick='window.location.href=\"/Publicacion/EditarVideo/".$value["id"]."\"'><i class='fa fa-edit' style='margin-right:0;'></i></span>
                            </li>";
                $shareVideoText="<li>
                                    <span class='btn btn-default tip' data-original-title='Publicar video' onclick='shareVideo($(this))' style='cursor:pointer;' data-video='".$value["id"]."' data-st='".$value["id_estatus"]."' ".$share." class='shareVideo'><i class='fa fa-cloud-upload' style='margin-right:0;'></i></span>
                                </li>";
                if($value["id_estatus"]==3)
                {
                    $disable="disabled";
                    $iconEstatus="fa-undo";
                    $shareVideoText="";
                    $tooltipEstatus="Restaurar video";
                    $descativarTitle="Restaurar";
                    $editVideoText="";
                }
                $action="<ul class='list-inline'>
                            <li>
                                <span class='btn btn-default tip' style='cursor:pointer;'  data-placement='top' data-video='".$value["youtube_id"]."' data-original-title='Ver video' onclick='seeVideo($(this))'><i class='fa fa-eye' style='margin-right:0;'></i></span>
                            </li>
                            ".$editVideoText."
                            <li>
                                <span class='btn btn-default tip' data-original-title='".$tooltipEstatus."' onclick='estatusVideo($(this))' data-video='".$value["id"]."' data-st='".$value["id_estatus"]."' style='cursor:pointer;' ".$disable."><i class='fa ".$iconEstatus."' title='".$descativarTitle."' style='margin-right:0;'></i></span>
                            </li>
                            ".$shareVideoText."
                        </ul>";
                $categorias="<ul>";
                $arrayCat=array();
                $subcategorias="<ul>";
                foreach ($value["cross_video_subcategoria"] as $key2 => $value2) {
                    if(!in_array($value2["cat_subcategorium"]["cat_categorium"]["descripcion"], $arrayCat))
                    {
                        $categorias.="<li>".$value2["cat_subcategorium"]["cat_categorium"]["descripcion"]."</li>";
                        array_push($arrayCat, $value2["cat_subcategorium"]["cat_categorium"]["descripcion"]);
                    }
                    $subcategorias.="<li>".$value2["cat_subcategorium"]["descripcion"]."</li>";
                }
                $categorias.="</ul>";
                $subcategorias.="</ul>";
                $series="<ul>";
                foreach ($value["cross_video_serie"] as $key2 => $value2) {
                    $series.="<li>".$value2["cat_serie"]["descripcion"]."</li>";
                }
                $series.="</ul>";
                $dataVideo=array(

                    "id"=>$value["id"],
                    "nombre"=>$value["nombre"],
                    "categorias"=>$categorias,
                    "subcategorias"=>$subcategorias,
                    "series"=>$series,
                    "estatus"=>"<label class='label ".$value["cat_estatus_video"]["label"]."'>".$value["cat_estatus_video"]["descripcion"]."</label>",
                    "action"=>$action

                );
                array_push($data, $dataVideo);
            }
        }
        $json=array(
            "recordsTotal"      =>  sizeof($videos),
            "recordsFiltered"   =>  sizeof($videos),
            "data"              =>  $data
        );
        echo json_encode($json);
    }
    public function NuevoVideo()
    {
        $active = 'nuevovideo';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Nuevo Video");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));   
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all")->contain(["CatSubcategoria"])->where(["estatus"=>1]);
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT),true);
        $this->loadModel("CatSerie");
        $series=$this->CatSerie->find("all")->where(["estatus"=>1]);
        $series=json_decode(json_encode($series,JSON_PRETTY_PRINT),true);
        $this->set("categorias",$categorias);
        $this->set("series",$series);
    }
    public function EditarVideo($video)
    {
        $active = 'nuevovideo';
        $this->set('active',$active);
        $this->viewBuilder()->layout('principal');
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Editar Video");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));   
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all")->contain(["CatSubcategoria"])->where(["estatus"=>1]);
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT),true);
        $this->loadModel("CatSerie");
        $series=$this->CatSerie->find("all")->where(["estatus"=>1]);
        $series=json_decode(json_encode($series,JSON_PRETTY_PRINT),true);
        $this->set("categorias",$categorias);
        $this->set("series",$series);
        $this->loadModel("Video");
        $video=$this->Video->find("all")->contain(["CrossVideoSubcategoria","CrossVideoSubcategoria.CatSubcategoria","CrossVideoSubcategoria.CatSubcategoria.CatCategoria",
            "CrossVideoSerie","CrossVideoSerie.CatSerie","CatEstatusVideo"])->where(["Video.id"=>$video]);
        $video=json_decode(json_encode($video,JSON_PRETTY_PRINT),true);
        $this->set("video",$video);
    }
    public function saveVideo()
    {
        $this->autoRender=false;
        $this->loadModel("Video");
        $newVideo=$this->Video->newEntity();
        if(isset($_POST["edicion"]))
        {
            $newVideo=$this->Video->get($_POST["edicion"]);
        }
        //
        $newVideo->youtube_id=$_POST["idYoutube"];
        $newVideo->nombre=$_POST["nombre"];
        $newVideo->descripcion=$_POST["descripcion"];
        $newVideo->imagen=$_POST["imagen"];
        $newVideo->date_publicacion=$_POST["fecha"];
        $newVideo->tags=$_POST["tags"];
        $newVideo->dislike=$_POST["dislikes"];
        $newVideo->likes_no=$_POST["likes"];
        $newVideo->views_no=$_POST["views"];
        $newVideo->id_usuario=$this->Auth->user("id");
        $exclusivo=0;
        if(isset($_POST["exclusivo"]))
        {
            $exclusivo=1;
        }
        $newVideo->solo_miembros=$exclusivo;
        $newVideo->id_estatus=$_POST["t"];
        if($this->Video->save($newVideo))
        {
            $this->loadModel("CrossVideoSubcategoria");
            if(isset($_POST["edicion"]))
            {
                $this->CrossVideoSubcategoria->deleteAll(["id_video"=>$_POST["edicion"]]);
            }
            foreach ($_POST["subcategoria"] as $key => $value) {

                $newSubcat=$this->CrossVideoSubcategoria->newEntity();
                $newSubcat->id_video=$newVideo->id;
                $newSubcat->id_subcategoria=$value;
                $this->CrossVideoSubcategoria->save($newSubcat);
            }
            $this->loadModel("CrossVideoSerie");
            if(isset($_POST["edicion"]))
            {
                $this->CrossVideoSerie->deleteAll(["id_video"=>$_POST["edicion"]]);
            }
            foreach ($_POST["serie"] as $key => $value) {

                $newSerie=$this->CrossVideoSerie->newEntity();
                $newSerie->id_video=$newVideo->id;
                $newSerie->id_serie=$value;
                $this->CrossVideoSerie->save($newSerie);
            }
            echo $_POST["t"];
        }
        else
        {
            echo 0;
        }
        
        //print_r($_POST);
    }
    function statusVideo($video)
    {
        $this->autoRender=false;
        $currentEstatus=$_POST["s"];
        $this->loadModel("Video");
        $videoEdit=$this->Video->newEntity();
        $videoEdit=$this->Video->get($video);
        switch ($currentEstatus) {
            case 1:
                $videoEdit->id_estatus=3;
                break;
            case 2:
                $videoEdit->id_estatus=3;
                break;
            case 3:
                $videoEdit->id_estatus=1;
                break;
            
            default:
                # code...
                break;
        }
        $this->Video->save($videoEdit);
        echo $videoEdit->id_estatus;
    }
    function ShareVideo($video)
    {
        $this->autoRender=false;
        $currentEstatus=$_POST["s"];
        $this->loadModel("Video");
        $videoEdit=$this->Video->newEntity();
        $videoEdit=$this->Video->get($video);
        if($currentEstatus==1) {
            $videoEdit->id_estatus=2;
        }
        $this->Video->save($videoEdit);
        echo $videoEdit->id_estatus;
    }
    
    /* =============================
        Function Google API 
    ================================ */
    function sampleAPI() {
        $client = new Google_Client();
        $client->setApplicationName("Client_Library_Examples");
        $client->setDeveloperKey("YOUR_APP_KEY");

        $service = new Google_Service_Books($client);
        $optParams = array('filter' => 'free-ebooks');
        $results = $service->volumes->listVolumes('Henry David Thoreau', $optParams);

        foreach ($results as $item) {
          echo $item['volumeInfo']['title'], "<br /> \n";
        }
    }
    function getDatavideo($videoId)
    {
        $this->autoRender=false;
        $DEVELOPER_KEY = 'AIzaSyDOkg-u9jnhP-WnzX5WPJyV1sc5QQrtuyc';
  
        $client = new Google_Client();  
        $client->setDeveloperKey($DEVELOPER_KEY); 
        $youtube = new Google_Service_YouTube($client);
        $listResponse = $youtube->videos->listVideos("snippet",
        array('id' => $videoId));
        $listResponse2 = $youtube->videos->listVideos("statistics",
        array('id' => $videoId));
        $snippet=json_decode(json_encode($listResponse->toSimpleObject()),true);
        $statistics=json_decode(json_encode($listResponse2->toSimpleObject()),true);
        if (empty($snippet["items"])) {
            $error=array("error"=>"Video no Encontrado");
            echo json_encode($error);
        }
        else
        {
            $datavideo=array("general"=>$snippet["items"][0]["snippet"],"estadisticas"=>$statistics["items"][0]["statistics"]);

            echo json_encode($datavideo);
        }
    }
    public function getAllVideos()
    {
        $this->autoRender=false;
        $this->loadModel("Video");
        $videos=$this->Video->find("all")->select(["id","youtube_id"]);
        $videos=json_decode(json_encode($videos,JSON_PRETTY_PRINT),true);
        echo json_encode($videos);
    }
    public function sincronizarVideos($id,$idYoutube)
    {
        //ini_set('max_execution_time', 0);
        $this->autoRender=false;
        $this->loadModel("Video");
        $jsonVideo=file_get_contents("http://".$_SERVER["SERVER_NAME"]."/Publicacion/getDatavideo/".$idYoutube);
    
        $arrVideo=json_decode($jsonVideo,true);
        //print_r($arrVideo);
        if(isset($arrVideo["estadisticas"]["viewCount"]))
        {
            if($arrVideo["estadisticas"]["viewCount"]!="")
            {
                $vidEdited=$this->Video->newEntity();
                $vidEdited=$this->Video->get($id);
                $vidEdited->dislike=$arrVideo["estadisticas"]["dislikeCount"];
                $vidEdited->likes_no=$arrVideo["estadisticas"]["likeCount"];
                $vidEdited->views_no=$arrVideo["estadisticas"]["viewCount"];
                $this->Video->save($vidEdited);
            }
            
        }

    }
    public function saveImage()
    {
        $this->autoRender=false;
        if (move_uploaded_file($_FILES['imgusr']['tmp_name'], getcwd()."/img/videos/".$_FILES["imgusr"]["name"])) {
            //echo "El fichero es válido y se subió con éxito.\n";
            echo "http://".$_SERVER["SERVER_NAME"]."/img/videos/".$_FILES["imgusr"]["name"];
        }
    }
    public function exampleVideo($videoId)
    {
        $this->autoRender=false;
        $DEVELOPER_KEY = 'AIzaSyDOkg-u9jnhP-WnzX5WPJyV1sc5QQrtuyc';
  
        $client = new Google_Client();  
        $client->setDeveloperKey($DEVELOPER_KEY); 
        $youtube = new Google_Service_YouTube($client);
        //print_r($youtube->videos->listVideos("",array('id' => $videoId)));
        
        $listResponse2 = $youtube->videos->listVideos("contentDetails",
        array('id' => $videoId));
        $details=json_decode(json_encode($listResponse2->toSimpleObject()),true);
        echo "<pre>";
        print_r($details);
        echo "</pre>";
    }
    public function updateTimes()
    {
        $this->autoRender=false;
        $DEVELOPER_KEY = 'AIzaSyDOkg-u9jnhP-WnzX5WPJyV1sc5QQrtuyc';
  
        $client = new Google_Client();  
        $client->setDeveloperKey($DEVELOPER_KEY); 
        
        $this->loadModel("Video");
        $videos=$this->Video->find("all")->select(["id","youtube_id"])->where(["duracion IS NULL"]);
        debug($videos);
        $videos=json_decode(json_encode($videos,JSON_PRETTY_PRINT),true);
        $youtube = new Google_Service_YouTube($client);
        foreach ($videos as $key => $value) {
            echo "1";
            /*$listResponse2 = $youtube->videos->listVideos("contentDetails",
            array('id' => $value["youtube_id"]));
            $details=json_decode(json_encode($listResponse2->toSimpleObject()),true);
            $time=$details["items"][0]["contentDetails"]["duration"];
            $hora=str_replace(array("PT","M","S"), array("",":",""), $time);*/
            //echo $hora;
            /*$hora=explode(":", $hora);*/
            /*print_r($hora);*/
            /*if(sizeof($hora)==1)
            {
                echo "<p>00:".str_pad($hora[0], 2,"0",STR_PAD_LEFT)."</p>";
            }
            else
            {
                echo "<p>".str_pad($hora[0], 2,"0",STR_PAD_LEFT).":".str_pad($hora[1], 2,"0",STR_PAD_LEFT)."</p>";
            }*/

        }
    }
}