<?php
namespace App\Controller;

require_once(ROOT . DS . 'vendor' . DS . "sendgrid" . DS . "sendgrid-php" . DS . "sendgrid-php.php");
use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Mailer\Email;
use SendGrid;

class UsersController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        // Allow users to register and logout.
        // You should not add the "login" action to allow list. Doing so would
        // cause problems with normal functioning of AuthComponent.
        $this->Auth->allow(['add', 'logout','resetPassword']);
    }

    public function index()
    {
        $users=json_decode($this->Users->GetAllUsers());
        $this->ApplicationInfo->Proyect('nombre_empresa');
        //print_r($users);
        $this->set('users',$users);
        $this->set('user',$this->Auth->user("id"));
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
    }

    public function view($id)
    {
        $user = $this->Users->get($id);
        $this->set(compact('user'));
    }

    public function add()
    {
        //Configure::read('SiteInfo');
        $roles=json_decode($this->Users->getRoles());
        $user = $this->Users->newEntity();
        $error="";
        $arrroles=array();
        foreach ($roles as $role) {
            $arrroles[$role->id]=$role->descripcion;
        }
        if ($this->request->is('post')) {
            $mail=$this->request->data["email"];
            $ExisteUser=$this->Users->find()->where(["username"=>$this->request->data["username"]])->first();
            //print_r($ExisteUser);
            if(empty($ExisteUser))
            {
                $user = $this->Users->patchEntity($user, $this->request->data);
                if ($this->Users->save($user)) {
                    $this->Flash->success(__('The user has been saved.'));
                    if($this->ApplicationInfo->Proyect('auth_type')==2)
                    {
                        /** SENDGRID EXAMPLE **/
                        /*$sendgrid = new SendGrid($this->ApplicationInfo->Proyect('sendgrid_key'));
                        $email = new SendGrid\Email();
                        $email
                            ->addTo($this->request->data['email']) 
                            ->setFrom($this->ApplicationInfo->Proyect('mail_default'))
                            ->setSubject(utf8_encode('asunto'))    
                            ->setHtml(' ')    
                            ->setText(' ')
                            ->setTemplateId("key_template");
                        $sendgrid->send($email);*/
                        /** Mail Default Cake **/
                        $mensaje='Mail para activar usuario, mail por default, para activar al usuario de click <a href="http://'.$_SERVER["SERVER_NAME"].'/Users/ActiveUser/'.$user->id.'">AQUI</a>';
                        $email = new Email('default');
                        $email->from([$this->ApplicationInfo->Proyect('mail_default') => $this->ApplicationInfo->Proyect('mailer_name')])
                            ->to($mail)
                            ->emailFormat('html')
                            ->subject('Activar Usuario')
                            ->send($mensaje);
                    }
                    return $this->redirect(['action' => 'add']);
                }
                $this->Flash->error(__('Unable to add the user.'));
                $error=__('No se pudo agregar el usuario, revise bien los campos.');
            }
            else
            {
                $this->Flash->error(__('Unable to add the user.'));
                $error=__('Este Usuario ya existe.');
            }
            
            
        }
        if($this->ApplicationInfo->Proyect('auth_type')==1)
        {
            $this->set('status',1);
        }
        else
        {
            $this->set('status',3);
        }
        //print_r($arrroles); 
        $this->set('error',$error);
        $this->set('roles',$arrroles);
        $this->set('user', $user);
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
    }

    public function resetPassword($idUser)
    {
        $error="";
        $user=$this->Users->get($idUser);
        if($this->request->is('post')) {
            $user = $this->Users->patchEntity($user, ['password'=>$this->request->data['new_password']]);
            if ($this->Users->save($user)) {
                $this->Flash->success(__('The user has been saved.'));
                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Unable to modify the user.'));
            $error=__('No se pudo cambiar la contrase&ntilde;a. Verifique que sean iguales.');
        }
        $this->set('error',$error);
        $this->set('user', $user);
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
    }


    public function login()
    {
        $this->viewBuilder()->layout('login');
        $error="";
        if ($this->request->is('post')) {
            $user = $this->Auth->identify();
            if ($user) {
                $this->Auth->setUser($user);
                return $this->redirect($this->Auth->redirectUrl());
            }
            $this->Flash->error(__('Invalid username or password, try again'));
            $error=__('Usuario o contrase&ntilde;a incorrectos.');
        }
        $this->set('error',$error);
        $this->set('description',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
    }

    public function logout()
    {
        return $this->redirect($this->Auth->logout());
    }

    public function deleteUser()
    {
        $this->autoRender=false;
        $this->Users->deleteUser($_POST);
    }

    public function statusUser()
    {
        $this->autoRender=false;
        $this->Users->statusUser($_POST);
    }
    public function editUser()
    {
        $this->autoRender=false;
        $user=$this->Users->newEntity();
        $user=$this->Users->get($_POST["iduser"]);
        $user->name=$_POST["name"];
        $user->username=$_POST["username"];
        $user->email=$_POST["email"];
        $user->role=$_POST["role"];
        if($this->Users->save($user))
        {
            echo 1;
        }
        else
        {
            echo 0;
        }
    }
}