<?php
namespace App\Controller;

require_once(ROOT . DS . 'vendor' . DS . "sendgrid" . DS . "sendgrid-php" . DS . "sendgrid-php.php");

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Mailer\Email;
use SendGrid;
use Cake\Database\Expression\QueryExpression;

class ConfiguracionController extends AppController
{
    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        // Allow users to register and logout.
        // You should not add the "login" action to allow list. Doing so would
        // cause problems with normal functioning of AuthComponent.
        $this->Auth->deny();
    }
    public function index()
    {
        $active = 'configuracion';
        $this->set('active',$active);
        $this->viewBuilder()->layout("principal");
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Configuracion");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
        
    }
    public function Usuarios()
    {   
        $active = 'configuracion';
        $this->set('active',$active);
        $this->viewBuilder()->layout("principal");
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Usuarios");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
    }
    public function Categorias()
    {
        $active = 'configuracion';
        $this->set('active',$active);
        $this->viewBuilder()->layout("principal");
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Categorias");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
    }
    public function Subcategorias()
    {
        $active = 'configuracion';
        $this->set('active',$active);
        $this->viewBuilder()->layout("principal");
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Subcategorias");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
    }
    public function Series()
    {
        $active = 'configuracion';
        $this->set('active',$active);
        $this->viewBuilder()->layout("principal");
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Series");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
    }
    public function Sliders()
    {
        $active = 'configuracion';
        $this->set('active',$active);
        $this->viewBuilder()->layout("principal");
        $this->ApplicationInfo->Proyect('nombre_empresa');
        $this->set('description',"Sliders");
        $this->set('title',$this->ApplicationInfo->Proyect('nombre_proyecto'));
        $this->set("diasIng",array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday"));
        $this->set("diasEsp",array("Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado","Domingo"));
        $this->set("mesIng",array("January","February","March","April","May","June","July","August","September","October","November","December"));
        $this->set("mesEsp",array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"));
        $this->set("username",$this->Auth->user("username"));
        $this->loadModel("Slider");
        $imgSlider=$this->Slider->find("all")->select(["id","img_desktop","img_smart","url","posicion","estatus"])->order(["posicion"]);
        $imgSlider=json_decode(json_encode($imgSlider,JSON_PRETTY_PRINT));
        $maxSliders=$this->Slider->find("all")->select(["activos"=>"count(id)"])->where(["estatus"=>1]);
        $maxSliders=json_decode(json_encode($maxSliders,JSON_PRETTY_PRINT));
        //print_r($maxSliders);
        $this->set('slider',$imgSlider);
        $this->set('maxSliders',$maxSliders[0]->activos);
    }
    public function getAllUSers()
    {
        $this->autoRender=false;
        $this->loadModel("Users");
        $users=$this->Users->find("all")->contain(["CatRoles","CatStatusUser"]);
        $users=json_decode(json_encode($users,JSON_PRETTY_PRINT),true);
        //print_r($users);
        $data=array();
        foreach ($users as $key => $value) {
            if($value["estatus"]==1)
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='2' style='cursor:pointer;'><i class='fa fa-trash-o' title='Desactivar'></i></span>";
            }
            else
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='1' style='cursor:pointer;'><i class='fa fa-check' title='Activar'></i></span>";
            }
            $action="<ul class='list-inline'>
                        <li>
                            <span style='cursor:pointer;' onclick='editCat($(this))' data-cat='".$value["id"]."' ><i class='fa fa-edit'></i></span>
                        </li>
                        <li>
                            ".$activar."
                        </li>
                    </ul>";
            $dataUser=array(

                "id"=>$value["id"],
                "username"=>$value["username"],
                "name"=>$value["name"],
                "email"=>$value["email"],
                "rol"=>$value["cat_role"]["descripcion"],
                "estatus"=>"<label class='label ".$value["cat_status_user"]["label"]."'>".$value["cat_status_user"]["description"]."</label>",
                "action"=>$action

            );
            array_push($data, $dataUser);
        }
        $json=array(
            "recordsTotal"      =>  sizeof($users),
            "recordsFiltered"   =>  sizeof($users),
            "data"              =>  $data
        );
        echo json_encode($json);
    }
    public function getAllCategorias()
    {
        $this->autoRender=false;
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all");
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT),true);
        //print_r($categorias);
        $data=array();
        foreach ($categorias as $key => $value) {
            if($value["estatus"]==1)
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='0' style='cursor:pointer;'><i class='fa fa-trash-o' title='Desactivar'></i></span>";
            }
            else
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='1' style='cursor:pointer;'><i class='fa fa-check' title='Activar'></i></span>";
            }
            $action="<ul class='list-inline'>
                        <li>
                            <span style='cursor:pointer;' onclick='editCat($(this))' data-cat='".$value["id"]."' data-name='".$value["descripcion"]."' 
                            data-desc='".$value["descripcion_larga"]."' data-imgn='".$value["imagen"]."'><i class='fa fa-edit'></i></span>
                        </li>
                        <li>
                            ".$activar."
                        </li>
                    </ul>";
            if($value["estatus"]==1)
            {
                $estatus="<label class='label label-success'>Activo</label>";
            }
            else
            {
                $estatus="<label class='label label-danger'>Desactivo</label>";
            }
            $dataUser=array(

                "id"=>$value["id"],
                "descripcion"=>$value["descripcion"],
                "estatus"=>$estatus,
                "action"=>$action

            );
            array_push($data, $dataUser);
        }
        $json=array(
            "recordsTotal"      =>  sizeof($categorias),
            "recordsFiltered"   =>  sizeof($categorias),
            "data"              =>  $data
        );
        echo json_encode($json);
   }
   public function getAllSubcategorias()
    {
        $this->autoRender=false;
        $this->loadModel("CatSubcategoria");
        $subcategorias=$this->CatSubcategoria->find("all")->contain(["CatCategoria"]);
        $subcategorias=json_decode(json_encode($subcategorias,JSON_PRETTY_PRINT),true);
        //print_r($subcategorias);
        $data=array();
        foreach ($subcategorias as $key => $value) {

            if($value["estatus"]==1)
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='0' style='cursor:pointer;'><i class='fa fa-trash-o' title='Desactivar'></i></span>";
            }
            else
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='1' style='cursor:pointer;'><i class='fa fa-check' title='Activar'></i></span>";
            }
            $action="<ul class='list-inline'>
                        <li>
                            <span style='cursor:pointer;' onclick='editSubCat($(this))' data-cat='".$value["id"]."' data-name='".$value["descripcion"]."' 
                            data-desc='".$value["descripcion_larga"]."' data-imgn='".$value["imagen"]."' data-categoria='".$value["id_categoria"]."'><i class='fa fa-edit'></i></span>
                        </li>
                        <li>
                            ".$activar."
                        </li>
                    </ul>";
            if($value["estatus"]==1)
            {
                $estatus="<label class='label label-success'>Activo</label>";
            }
            else
            {
                $estatus="<label class='label label-danger'>Desactivo</label>";
            }
            $dataUser=array(

                "id"=>$value["id"],
                "categoria"=>$value["cat_categorium"]["descripcion"],
                "descripcion"=>$value["descripcion"],
                "estatus"=>$estatus,
                "action"=>$action

            );
            array_push($data, $dataUser);
        }
        $json=array(
            "recordsTotal"      =>  sizeof($subcategorias),
            "recordsFiltered"   =>  sizeof($subcategorias),
            "data"              =>  $data
        );
        echo json_encode($json);
   }
   public function getAllSeries()
    {
        $this->autoRender=false;
        $this->loadModel("CatSerie");
        $series=$this->CatSerie->find("all");
        $series=json_decode(json_encode($series,JSON_PRETTY_PRINT),true);
        //print_r($series);
        $data=array();
        foreach ($series as $key => $value) {

            if($value["estatus"]==1)
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='0' style='cursor:pointer;'><i class='fa fa-trash-o' title='Desactivar'></i></span>";
            }
            else
            {
                $activar="<span onclick='estatusCat($(this))' data-cat='".$value["id"]."' data-st='1' style='cursor:pointer;'><i class='fa fa-check' title='Activar'></i></span>";
            }
            $action="<ul class='list-inline'>
                        <li>
                            <span style='cursor:pointer;' onclick='editCat($(this))' data-cat='".$value["id"]."' data-name='".$value["descripcion"]."'><i class='fa fa-edit'></i></span>
                        </li>
                        <li>
                            ".$activar."
                        </li>
                    </ul>";
            if($value["estatus"]==1)
            {
                $estatus="<label class='label label-success'>Activo</label>";
            }
            else
            {
                $estatus="<label class='label label-danger'>Desactivo</label>";
            }
            $dataUser=array(

                "id"=>$value["id"],
                "descripcion"=>$value["descripcion"],
                "estatus"=>$estatus,
                "action"=>$action

            );
            array_push($data, $dataUser);
        }
        $json=array(
            "recordsTotal"      =>  sizeof($series),
            "recordsFiltered"   =>  sizeof($series),
            "data"              =>  $data
        );
        echo json_encode($json);
    }
    public function FormNewCategoria()
    {
        //ini_set ( "file_uploads" , "On" );
        $this->viewBuilder()->layout("ajax");

    }
    public function FormNewSubcategoria()
    {
        $this->viewBuilder()->layout("ajax");        
        $this->loadModel("CatCategoria");
        $categorias=$this->CatCategoria->find("all")->where(["estatus"=>1]);
        $categorias=json_decode(json_encode($categorias,JSON_PRETTY_PRINT),true);
        $this->set("categorias",$categorias);

    }
    public function FormNewUser()
    {
        $this->viewBuilder()->layout("ajax");
        $this->loadModel("CatRoles");
        $roles=$this->CatRoles->find("all")->where(["estatus"=>1]);
        $roles=json_decode(json_encode($roles,JSON_PRETTY_PRINT),true);
        $this->set("roles",$roles);
    }
    public function FormEditUser()
    {
        $user=$_POST["u"];
        $this->viewBuilder()->layout("ajax");
        $this->loadModel("CatRoles");
        $roles=$this->CatRoles->find("all")->where(["estatus"=>1]);
        $roles=json_decode(json_encode($roles,JSON_PRETTY_PRINT),true);
        $this->set("roles",$roles);
        $this->loadModel("Users");
        $userinfo=$this->Users->get($user);
        $userinfo=json_decode(json_encode($userinfo,JSON_PRETTY_PRINT),true);
        $this->set("usuario",$userinfo);
    }
    public function newCategoria()
    {
        $this->autoRender=false;
        if (move_uploaded_file($_FILES['catImg']['tmp_name'], getcwd()."/img/categorias/".$_FILES["catImg"]["name"])) {
            //echo "El fichero es válido y se subió con éxito.\n";
            $this->loadModel("CatCategoria");
            $newCat=$this->CatCategoria->newEntity();
            if(isset($_POST["edicion"]))
            {
                $newCat=$this->CatCategoria->get($_POST["edicion"]);
            }
            $newCat->id_usuario=$this->Auth->user("id");
            $newCat->descripcion=$_POST["catName"];
            $newCat->descripcion_larga=$_POST["catDesc"];
            $newCat->imagen="/img/categorias/".$_FILES["catImg"]["name"];
            if($this->CatCategoria->save($newCat)){
                echo 1;
            }   
        }
        else
        {
            $this->loadModel("CatCategoria");
            $newCat=$this->CatCategoria->newEntity();
            if(isset($_POST["edicion"]))
            {
                $newCat=$this->CatCategoria->get($_POST["edicion"]);
            }
            $newCat->id_usuario=$this->Auth->user("id");
            $newCat->descripcion=$_POST["catName"];
            $newCat->descripcion_larga=$_POST["catDesc"];
            $newCat->imagen=$_POST["crrImg"];
            if($this->CatCategoria->save($newCat)){
                echo 1;
            } 
        }
        /*
        $this->redirect("/Configuracion/Categorias");*/
    }
    public function newSerie()
    {
        $this->autoRender=false;
        $this->loadModel("CatSerie");
        $newCat=$this->CatSerie->newEntity();
        if(isset($_POST["edicion"]))
        {
            $newCat=$this->CatSerie->get($_POST["edicion"]);
        }
        $newCat->id_usuario=$this->Auth->user("id");
        $newCat->descripcion=$_POST["catName"];
        if($this->CatSerie->save($newCat)){
            echo 1;
        }
    }
    public function newSubcategoria()
    {
        /*print_r($_POST);
        print_r($_FILES);*/
        $this->autoRender=false;
        if (move_uploaded_file($_FILES['catImg']['tmp_name'], getcwd()."/img/categorias/".$_FILES["catImg"]["name"])) {
            $this->loadModel("CatSubcategoria");
            $newCat=$this->CatSubcategoria->newEntity();
            if(isset($_POST["edicion"]))
            {
                $newCat=$this->CatSubcategoria->get($_POST["edicion"]);
            }
            $newCat->id_usuario=$this->Auth->user("id");
            $newCat->id_categoria=$_POST["idCat"];
            $newCat->descripcion=$_POST["catName"];
            $newCat->descripcion_larga=$_POST["catDesc"];
            $newCat->imagen="/img/categorias/".$_FILES["catImg"]["name"];
            if($this->CatSubcategoria->save($newCat)){
                echo 1;
            }
        }
        else
        {
            $this->loadModel("CatSubcategoria");
            $newCat=$this->CatSubcategoria->newEntity();
            if(isset($_POST["edicion"]))
            {
                $newCat=$this->CatSubcategoria->get($_POST["edicion"]);
            }
            $newCat->id_usuario=$this->Auth->user("id");
            $newCat->id_categoria=$_POST["idCat"];
            $newCat->descripcion=$_POST["catName"];
            $newCat->descripcion_larga=$_POST["catDesc"];
            $newCat->imagen=$_POST["crrImg"];
            if($this->CatSubcategoria->save($newCat)){
                echo 1;
            }
        }
    }
    function statusCategoria($cat){
        $this->autoRender=false;
        $this->loadModel("CatCategoria");
        $categoria=$this->CatCategoria->newEntity();
        $categoria=$this->CatCategoria->get($cat);
        $categoria->estatus=$_POST["s"];
        if($this->CatCategoria->save($categoria))
        {
            echo $categoria->estatus;
        }

    }
    function statusSubcategoria($cat){
        $this->autoRender=false;
        $this->loadModel("CatSubcategoria");
        $Subcategoria=$this->CatSubcategoria->newEntity();
        $Subcategoria=$this->CatSubcategoria->get($cat);
        $Subcategoria->estatus=$_POST["s"];
        if($this->CatSubcategoria->save($Subcategoria))
        {
            echo $Subcategoria->estatus;
        }
    }
    function statusSerie($cat){
        $this->autoRender=false;
        $this->loadModel("CatSerie");
        $Serie=$this->CatSerie->newEntity();
        $Serie=$this->CatSerie->get($cat);
        $Serie->estatus=$_POST["s"];
        if($this->CatSerie->save($Serie))
        {
            echo $Serie->estatus;
        }
    }
    function statusUser($user)
    {
        $this->autoRender=false;
        $this->loadModel("Users");
        $usuario=$this->Users->newEntity();
        $usuario=$this->Users->get($user);
        $usuario->estatus=$_POST["s"];
        if($this->Users->save($usuario))
        {
            echo $usuario->estatus;
        }
    }
    function statusSlider($idSlider)
    {
        $newEstatus=1;
        if(!isset($_POST["estatus"]))
        {
            return;
        }
        elseif($_POST["estatus"]==1)
        {
            $newEstatus=2;
        }
        $this->autoRender=false;
        $this->loadModel("Slider");
        $editedSlider=$this->Slider->newEntity();
        $editedSlider=$this->Slider->get($idSlider);
        $editedSlider->estatus=$newEstatus;
        if($_POST["estatus"]==1)
        {
            $expression = new QueryExpression('posicion = posicion - 1');
            //$expression2 = new QueryExpression('posicion < posicion - 1');
            $posActual=$editedSlider->posicion;
            $this->Slider->updateAll(
                [$expression],
                ['posicion >'=>$posActual]
            );
            $editedSlider->posicion=0;
        }
        else
        {
            $maxSliders=$this->Slider->find("all")->select(["mayor"=>"max(posicion)"])->where(["estatus"=>1])->group(["estatus"]);
            $maxSliders=json_decode(json_encode($maxSliders,JSON_PRETTY_PRINT));
            //echo $maxSliders[0]->mayor;
            $editedSlider->posicion=($maxSliders[0]->mayor)+1;
        }
        if($this->Slider->save($editedSlider))
        {
            echo $newEstatus;
        }
    }
    function savePosiciones()
    {
        $this->autoRender=false;
        //print_r($_POST);
        $this->loadModel("Slider");
        $posiciones=json_decode($_POST["posiciones"]);
        foreach ($posiciones as $key => $value) {
            $editedSlider=$this->Slider->newEntity();
            $editedSlider=$this->Slider->get($value[0]);
            $editedSlider->posicion=$value[1];
            $this->Slider->save($editedSlider);
        }
    }
    function FormNuevoSlider()
    {
        $this->viewBuilder()->layout("ajax");
    }
    function newSlider()
    {
        $this->autoRender=false;
        if(move_uploaded_file($_FILES['ImgDsk']['tmp_name'], getcwd()."/img/slider/".$_FILES["ImgDsk"]["name"])&&move_uploaded_file($_FILES['ImgSmt']['tmp_name'], getcwd()."/img/slider/".$_FILES["ImgSmt"]["name"]))
        {
            $this->loadModel("Slider");
            $newSlider=$this->Slider->newEntity();
            if(isset($_POST["id"]))
            {
                $newSlider=$this->Slider->get($_POST["id"]);
            }
            $newSlider->url=$_POST["sliderUrl"];
            if(isset($_FILES["ImgDsk"]["name"]))
            {
                $newSlider->img_desktop="/img/slider/".$_FILES["ImgDsk"]["name"];
            }
            else
            {
                $newSlider->img_desktop=$_POST["crrImgDsk"];
            }
            if(isset($_FILES["ImgSmt"]["name"]))
            {
                $newSlider->img_smart="/img/slider/".$_FILES["ImgSmt"]["name"];
            }
            else
            {
                $newSlider->img_smart=$_POST["crrImgSmt"];
            }
            $newSlider->estatus=1;

            $maxSliders=$this->Slider->find("all")->select(["mayor"=>"max(posicion)"])->where(["estatus"=>1])->group(["estatus"]);
            $maxSliders=json_decode(json_encode($maxSliders,JSON_PRETTY_PRINT));

            $newSlider->posicion=($maxSliders[0]->mayor)+1;

            if($this->Slider->save($newSlider)){
                echo 1;
            }
        }
        /*print_r($_POST);
        print_r($_FILES);*/
    }
}