<div class="row">
	<div class="col-xs-12">
		<form id="newUserForm">
			<input name="iduser" type="hidden" value="<?= $usuario["id"]?>">
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Nombre:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="text" id="name" name="name" value="<?= $usuario["name"]?>">
				</div>
			</div>
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Usuario:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="text" id="username" name="username" value="<?= $usuario["username"]?>">
				</div>
			</div>
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Correo:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="text" id="email" name="email" value="<?= $usuario["email"]?>">
				</div>
			</div>
			
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Rol:</label>
				<div class="col-xs-12 col-md-9">
					<select class='form-control' name="role" id="role">
						<option value="0">Selecciona un Rol</option>
						<?foreach ($roles as $key => $value) {?>
						<option value="<?= $value["id"]?>" <?= ($value["id"]==$usuario["role"]) ? "selected" : "" ?>><?= $value["descripcion"]?></option>
						<?}?>
					</select>
				</div>
			</div>
		</form>
	</div>
</div>
<script src="/js/plugins/forms/validation/jquery.validate.js"></script>
<script>
	$(document).ready(function(){
		$("#newUserForm").validate({
			rules : {
				name : {
					required : true
				},
				username : {
					required : true
				},
				email : {
					required : true,
					email : true
				},
				role : {
					required : true,
					min : 1
				}
			},
			messages : {
				name : {
					required : "Este campo es obligatorio"
				},
				username : {
					required : "Este campo es obligatorio"
				},
				email : {
					required : "Este campo es obligatorio",
					email : "Introduce un correo v&aacute;lido"
				},
				role : {
					required : "Este campo es obligatorio",
					min : "Este campo es obligatorio"
				}
			},
	    	submitHandler: function(form) {
	            
	    		$.ajax({
					url : "/Users/editUser",
					data : $("#newUserForm").serialize(),
					type : "POST",
					async: false
				})
				.done(function(msg){
			   	
			   		if(msg==1)
			   		{	
			   			$("#tablaUsuarios").dataTable().fnDestroy();
	                    setTimeout(function(){
	                        doTable();
	                    },1000);
						bootbox.alert("Se ha editado correctamente el usuario");
						bootbox.hideAll();
			   		}
					else
					{
						bootbox.alert("Algo sali&oacute; mal, intenta m&aacute;s tarde");
					}
				})
			}
		})
	})
</script>