<div class="row">
	<div class="col-xs-12">
		<form id="newUserForm">
			<input name="estatus" type="hidden" value="3">
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Nombre:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="text" id="name" name="name">
				</div>
			</div>
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Usuario:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="text" id="username" name="username">
				</div>
			</div>
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Correo:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="text" id="email" name="email">
				</div>
			</div>
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Contrase&ntilde;a:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="password" id="password" name="password">
				</div>
			</div>
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Repite Contrase&ntilde;a:</label>
				<div class="col-xs-12 col-md-9">
					<input class='form-control' type="password" id="confirm_password" name="confirm_password">
				</div>
			</div>
			<div class="form-group col-xs-12">
				<label class='control-label col-xs-12 col-md-3'>Rol:</label>
				<div class="col-xs-12 col-md-9">
					<select class='form-control' name="role" id="role">
						<option value="0">Selecciona un Rol</option>
						<?foreach ($roles as $key => $value) {?>
						<option value="<?= $value["id"]?>"><?= $value["descripcion"]?></option>
						<?}?>
					</select>
				</div>
			</div>
		</form>
	</div>
</div>
<script src="/js/plugins/forms/validation/jquery.validate.js"></script>
<script>
	$(document).ready(function(){
		$("#newUserForm").validate({
			rules : {
				name : {
					required : true
				},
				username : {
					required : true
				},
				email : {
					required : true,
					email : true
				},
				password : {
					required : true,
					minlength: 6
				},
				confirm_password : {
					equalTo : "#password"
				},
				role : {
					required : true,
					min : 1
				}
			},
			messages : {
				name : {
					required : "Este campo es obligatorio"
				},
				username : {
					required : "Este campo es obligatorio"
				},
				email : {
					required : "Este campo es obligatorio",
					email : "Introduce un correo v&aacute;lido"
				},
				password : {
					required : "Este campo es obligatorio",
					minlength: "La contrase&ntilde;a debe tener al menos 6 caracteres"
				},
				confirm_password : {
					equalTo : "Las contrase&ntilde;as no coinciden"
				},
				role : {
					required : "Este campo es obligatorio",
					min : "Este campo es obligatorio"
				}
			},
	    	submitHandler: function(form) {
	            
	    		$.ajax({
					url : "/Users/add",
					data : $("#newUserForm").serialize(),
					type : "POST",
					async: false
				})
				.done(function(msg){
			   
					$("#tablaUsuarios").dataTable().fnDestroy();
                    setTimeout(function(){
                        doTable();
                    },1000);
					bootbox.alert("Se ha agregado correctamente el usuario");
					bootbox.hideAll();

				})
			}
		})
	})
</script>