<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.10.0
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */
use Cake\Cache\Cache;
use Cake\Core\Configure;
use Cake\Core\Plugin;
use Cake\Datasource\ConnectionManager;
use Cake\Error\Debugger;
use Cake\Http\Exception\NotFoundException;

$this->disableAutoLayout();

if (!Configure::read('debug')) :
    throw new NotFoundException(
        'Please replace templates/Pages/home.php with your own version or re-enable debug mode.'
    );
endif;
?>
<!DOCTYPE html>
<!--[if lt IE 8]><html class="no-js lt-ie8"> <![endif]-->
<html class="no-js">
    <head>
        <meta charset="utf-8">
        <title><?= $description?> | <?= $title?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <!--[if IE]><meta http-equiv="x-ua-compatible" content="IE=9" /><![endif]-->
        <meta name="author" content="" />
        <meta name="description" content="" />
        <meta name="keywords" content="" />
        <meta name="application-name" content="" />
        
        <?=$this->Html->css(array(
                                    'http://fonts.googleapis.com/css?family=Open+Sans:400,700',
                                    'http://fonts.googleapis.com/css?family=Droid+Sans:400,700',
                                    'icons.css',
                                    'bootstrap.css',
                                    'plugins.css',
                                    'main.css',
                                    'custom.css'
        ))?>
        <link rel="icon" href="/img/favicon.png" type="image/png">
        <meta name="msapplication-TileColor" content="#3399cc" />
        <?=$this->Html->script(array(
                                        'plugins/core/pace/pace.min.js',
                                        'http://code.jquery.com/jquery-2.1.1.min.js'
                                    )
                                );
        ?>
        <script>
        window.jQuery || document.write('<script src="js/libs/jquery-2.1.1.min.js">\x3C/script>')
        </script>
        <?=$this->Html->script(array('http://code.jquery.com/ui/1.10.4/jquery-ui.js'))?>
        <script>
        window.jQuery || document.write('<script src="js/libs/jquery-ui-1.10.4.min.js">\x3C/script>')
        </script>
        <?=$this->Html->script(array('http://code.jquery.com/jquery-migrate-1.2.1.min.js'))?>
        <script>
        window.jQuery || document.write('<script src="js/libs/jquery-migrate-1.2.1.min.js">\x3C/script>')
        </script>
       <?=$this->Html->script(array(
                                        'bootstrap/bootstrap.min.js',
                                        'libs/modernizr.custom.js'
        
        ))?>
    </head>
    <body>
        <!--[if lt IE 9]>
            <p class="browsehappy">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
        <![endif]-->
        <div id="header">
            <?= $this->element('menu')?>
        </div>
        <div id="wrapper">
            <div id="sidebarbg" class="hidden-lg hidden-md hidden-sm hidden-xs"></div>
            <div id="sidebar" class="page-sidebar hidden-lg hidden-md hidden-sm hidden-xs">
                <?= $this->element('sidebar_left')?>
            </div>
            <div id="content" class="page-content clearfix">
                <?= $this->fetch('content') ?>
            </div>
            
            <div id="footer" class="clearfix sidebar-page">
                <p class="pull-left">
                    &copy; 2016 Copyright Sensey. Todos los derechos reservados
                </p>
            </div>
        </div>
        <div id="back-to-top"><a href="#">Back to Top</a></div>
        
         <!--[if lt IE 9]>
        <?=$this->Html->script(array(
                                        'libs/excanvas.min.js',
                                        'http://html5shim.googlecode.com/svn/trunk/html5.js',
                                        'libs/respond.min.js',
        
        ))?>
        <![endif]-->
        <?=$this->Html->script(array(
                                        'jRespond.min.js',
                                        'plugins/core/slimscroll/jquery.slimscroll.min.js',
                                        'plugins/core/slimscroll/jquery.slimscroll.horizontal.min.js',
                                        'plugins/core/fastclick/fastclick.js',
                                        'plugins/core/velocity/jquery.velocity.min.js',
                                        'plugins/ui/bootbox/bootbox.js',
                                        'jquery.supr.js',
                                        'main.js'
        
        ))?>
        <!--<script src="js/pages/dashboard.js"></script>-->
        
    </body>
</html>        