<?php
/**
 * This sample sets and retrieves localized metadata for a video by:
 *
 * 1. Updating language of the default metadata and setting localized metadata
 *   for a video via "videos.update" method.
 * 2. Getting the localized metadata for a video in a selected language using the
 *   "videos.list" method and setting the "hl" parameter.
 * 3. Listing the localized metadata for a video using the "videos.list" method and
 *   including "localizations" in the "part" parameter.
 *
 * @author Ibrahim Ulukaya
 */
/**
 * Library Requirements
 *
 * 1. Install composer (https://getcomposer.org)
 * 2. On the command line, change to this directory (api-samples/php)
 * 3. Require the google/apiclient library
 *    $ composer require google/apiclient:~2.0
 */
 $fileLib = $_SERVER["DOCUMENT_ROOT"].'/webroot/php/google-api-php-client/vendor/autoload.php';
if (!file_exists($fileLib)) {
  throw new \Exception('please run "composer require google/apiclient:~2.0" in "' . __DIR__ .'"');
}
require_once $fileLib;

session_start();

$htmlBody = <<<END
<form method="GET">
  <div>
    Action:
    <select id="action" name="action">
      <option value="set">Set Localization - Fill in: video ID, default language, language, title and description</option>
      <option value="get">Get Localization- Fill in: video ID, language</option>
      <option value="list">List Localizations - Fill in: video ID, language</option>
    </select>
  </div>
  <br>
  <div>
    Video ID: <input type="text" id="videoId" name="videoId" placeholder="Enter Video ID">
  </div>
  <br>
  <div>
    Default Language: <input type="text" id="defaultLanguage" name="defaultLanguage" placeholder="Enter Default Language (BCP-47 language code)">
  </div>
  <br>
  <div>
    Language: <input type="text" id="language" name="language" placeholder="Enter Local Language (BCP-47 language code)">
  </div>
  <br>
  <div>
    Title: <input type="text" id="title" name="title" placeholder="Enter Title">
  </div>
  <br>
  <div>
    Description: <input type="text" id="description" name="description" placeholder="Enter Description">
  </div>
  <br>
  <input type="submit" value="GO!">
</form>
END;
/*
 * You can acquire an OAuth 2.0 client ID and client secret from the
 * {{ Google Cloud Console }} <{{ https://cloud.google.com/console }}>
 * For more information about using OAuth 2.0 to access Google APIs, please see:
 * <https://developers.google.com/youtube/v3/guides/authentication>
 * Please ensure that you have enabled the YouTube Data API for your project.
 */ 				 
$OAUTH2_CLIENT_ID = '901534055919-lm99bqs1ppamvfk74arb727ad7nfhl1r.apps.googleusercontent.com';
$OAUTH2_CLIENT_SECRET = 'PaZl4HqOZcMLoaGvNcwmvhNQ';
$DEVELOPER_KEY = "AIzaSyDOkg-u9jnhP-WnzX5WPJyV1sc5QQrtuyc";
// Sensey WF $DEVELOPER_KEY = 'AIzaSyBAQyXCnEjp_viNuJ_L6ZQ5lGr9_1NMCOI'; 
// GRAL      $DEVELOPER_KEY = 'AIzaSyDOkg-u9jnhP-WnzX5WPJyV1sc5QQrtuyc';
$client = new Google_Client();
$client->setDeveloperKey($DEVELOPER_KEY); 
$client->setClientId($OAUTH2_CLIENT_ID);
$client->setClientSecret($OAUTH2_CLIENT_SECRET);
/*
 * This OAuth 2.0 access scope allows for full read/write access to the
 * authenticated user's account.
 */
$client->setScopes('https://www.googleapis.com/auth/youtube');
$redirect = filter_var('http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'],
    FILTER_SANITIZE_URL);
$client->setRedirectUri($redirect);
// Define an object that will be used to make all API requests.
$youtube = new Google_Service_YouTube($client);
// Check if an auth token exists for the required scopes
$tokenSessionKey = 'token-' . $client->prepareScopes();
if (isset($_GET['code'])) {
  if (strval($_SESSION['state']) !== strval($_GET['state'])) {
    die('The session state did not match.');
  }
  $client->authenticate($_GET['code']);
  $_SESSION[$tokenSessionKey] = $client->getAccessToken();
  header('Location: ' . $redirect);
}
if (isset($_SESSION[$tokenSessionKey])) {
  $client->setAccessToken($_SESSION[$tokenSessionKey]);
}

// Check to ensure that the access token was successfully acquired.
if ($client->getAccessToken()) {
  // This code executes if the user enters an action in the form
  // and submits the form. Otherwise, the page displays the form above.
  if (isset($_GET['action'])) {
    $htmlBody = '';
    $videoId = $_GET['videoId'];
    $language = $_GET['language'];
    $defaultLanguage = $_GET['defaultLanguage'];
    $title = $_GET['title'];
    $description = $_GET['description'];
    try {
      switch ($_GET['action']) {
        case 'set':
          setVideoLocalization($youtube, $videoId, $defaultLanguage,
              $language, $title, $description, $htmlBody);
          break;
        case 'get':
          getVideoLocalization($youtube, $videoId, $language, $htmlBody);
          break;
        case 'list':
          listVideoLocalizations($youtube, $videoId, $htmlBody);
          break;
      }
    } catch (Google_Service_Exception $e) {
      $htmlBody .= sprintf('<p>A service error occurred: <code>%s</code></p>',
          htmlspecialchars($e->getMessage()));
    } catch (Google_Exception $e) {
      $htmlBody .= sprintf('<p>An client error occurred: <code>%s</code></p>',
          htmlspecialchars($e->getMessage()));
    }
  }
$_SESSION[$tokenSessionKey] = $client->getAccessToken();
} elseif ($OAUTH2_CLIENT_ID == 'REPLACE_ME') {
  $htmlBody = <<<END
  <h3>Client Credentials Required</h3>
  <p>
    You need to set <code>\$OAUTH2_CLIENT_ID</code> and
    <code>\$OAUTH2_CLIENT_ID</code> before proceeding.
  <p>
END;
} else {
  // If the user hasn't authorized the app, initiate the OAuth flow
  $state = mt_rand();
  $client->setState($state);
  $_SESSION['state'] = $state;
  $authUrl = $client->createAuthUrl();
  $htmlBody = <<<END
  <h3>Authorization Required</h3>
  <p>You need to <a href="$authUrl">authorize access</a> before proceeding.<p>
END;
}
/**
 * Updates a video's default language and sets its localized metadata.
 *
 * @param Google_Service_YouTube $youtube YouTube service object.
 * @param string $videoId The id parameter specifies the video ID for the resource
 * that is being updated.
 * @param string $defaultLanguage The language of the video's default metadata
 * @param string $language The language of the localized metadata
 * @param string $title The localized title to be set
 * @param string $description The localized description to be set
 * @param $htmlBody - html body.
 */
function setVideoLocalization(Google_Service_YouTube $youtube, $videoId, $defaultLanguage,
    $language, $title, $description, &$htmlBody) {
  // Call the YouTube Data API's videos.list method to retrieve videos.
  $videos = $youtube->videos->listVideos("snippet,localizations", array(
      'id' => $videoId
  ));
  // If $videos is empty, the specified video was not found.
  if (empty($videos)) {
    $htmlBody .= sprintf('<h3>Can\'t find a video with video id: %s</h3>', $videoId);
  } else {
    // Since the request specified a video ID, the response only
    // contains one video resource.
    $updateVideo = $videos[0];
    // Modify video's default language and localizations properties.
    // Ensure that a value is set for the resource's snippet.defaultLanguage property.
    $updateVideo['snippet']['defaultLanguage'] = $defaultLanguage;
    $localizations = $updateVideo['localizations'];
    if (is_null($localizations)) {
      $localizations = array();
    }
    $localizations[$language] = array('title' => $title, 'description' => $description);
    $updateVideo['localizations'] = $localizations;
    // Call the YouTube Data API's videos.update method to update an existing video.
    $videoUpdateResponse = $youtube->videos->update("snippet,localizations", $updateVideo);
    $htmlBody .= "<h2>Updated video</h2><ul>";
    $htmlBody .= sprintf('<li>(%s) default language: %s</li>', $videoId,
        $videoUpdateResponse['snippet']['defaultLanguage']);
    $htmlBody .= sprintf('<li>title(%s): %s</li>', $language,
        $videoUpdateResponse['localizations'][$language]['title']);
    $htmlBody .= sprintf('<li>description(%s): %s</li>', $language,
        $videoUpdateResponse['localizations'][$language]['description']);
    $htmlBody .= '</ul>';
  }
}
/**
 * Returns localized metadata for a video in a selected language.
 * If the localized text is not available in the requested language,
 * this method will return text in the default language.
 *
 * @param Google_Service_YouTube $youtube YouTube service object.
 * @param string $videoId The videoId parameter instructs the API to return the
 * localized metadata for the video specified by the video id.
 * @param string language The language of the localized metadata.
 * @param $htmlBody - html body.
 */
function getVideoLocalization(Google_Service_YouTube $youtube, $videoId, $language, &$htmlBody) {
  // Call the YouTube Data API's videos.list method to retrieve videos.
  $videos = $youtube->videos->listVideos("snippet,statistics", array(
      'id' => $videoId,
      'hl' => $language
  ));
  // If $videos is empty, the specified video was not found.
  if (empty($videos)) {
    $htmlBody .= sprintf('<h3>Can\'t find a video with video id: %s</h3>', $videoId);
  } else {
    // Since the request specified a video ID, the response only
    // contains one video resource.
    $localized = $videos[0]["snippet"];
    print_r($videos[0]["snippet"]);
	print "<br>__________________<br><br><br>";
	print_r($videos[0]["statistics"]);
	
	/*
	
	Google_Service_YouTube_VideoSnippet Object ( 
		[collection_key:protected] => tags 
		[categoryId] => 24 
		[channelId] => UCt1Atg__0HLMTozCJc6w6Zg 
		[channelTitle] => Sensey Electronics 
		[defaultAudioLanguage] => 
		[defaultLanguage] => 
		[description] => Soundcheck 2016, Segundo capitulo de nuestra sala de exhibición, Karem y Karely nos platican de novedadades Consola Claymore, presentación de equipo Elipsis, entre otras cosas 
		[liveBroadcastContent] => none 
		[localizedType:protected] => Google_Service_YouTube_VideoLocalization 
		[localizedDataType:protected] => 
		[publishedAt] => 2016-04-19T19:01:12.000Z 
		[tags] => Array ( [0] => audio [1] => mezcladora [2] => elipsis [3] => krieg [4] => sensey [5] => senseytv [6] => senseyelectronics [7] => backsatge [8] => auric [9] => mipro [10] => eminence [11] => bms [12] => paudio [13] => gorila [14] => soundcheck [15] => 2016 [16] => concierto [17] => sonido ) 
		[thumbnailsType:protected] => Google_Service_YouTube_ThumbnailDetails 
		[thumbnailsDataType:protected] => 
		[title] => SenseyTV en Soundcheck 2016 Capitulo 2 
		[internal_gapi_mappings:protected] => Array ( ) 
		[modelData:protected] => Array ( [thumbnails] => Array ( [default] => Array ( [url] => https://i.ytimg.com/vi/t3DldFtE7Mw/default.jpg [width] => 120 [height] => 90 ) [medium] => Array ( [url] => https://i.ytimg.com/vi/t3DldFtE7Mw/mqdefault.jpg [width] => 320 [height] => 180 ) [high] => Array ( [url] => https://i.ytimg.com/vi/t3DldFtE7Mw/hqdefault.jpg [width] => 480 [height] => 360 ) [standard] => Array ( [url] => https://i.ytimg.com/vi/t3DldFtE7Mw/sddefault.jpg [width] => 640 [height] => 480 ) [maxres] => Array ( [url] => https://i.ytimg.com/vi/t3DldFtE7Mw/maxresdefault.jpg [width] => 1280 [height] => 720 ) ) 
	 ) ) 
	*/
	print "<li>description: ".$localized['description']."</li>";
	print "<li>publishedAt: ".$localized['publishedAt']."</li>";
	print "<li>title: ".$localized['title']."</li>";
	foreach ($localized['tags'] as $t) {
		$strTags .= $t.", ";
	}
	$strTagsAux = preg_replace('/,(,*)$/', html_entity_decode(' ').'$1', $strTags);
	print "<li>tags: ".$strTagsAux."</li>";
	print "<li>thumb: ".$localized['modelData']['thumbnails']['medium']['url']."</li>";
    $htmlBody .= "<h3>Video</h3><ul>";
    $htmlBody .= sprintf('<li>title(%s): %s</li>', $language, $localized['title']);
    $htmlBody .= sprintf('<li>description(%s): %s</li>', $language, $localized['description']);
    $htmlBody .= sprintf('<li>publishedAt(%s): %s</li>', $language, $localized['publishedAt']);
    $htmlBody .= sprintf('<li>channelTitle(%s): %s</li>', $language, $localized['channelTitle']);
    $htmlBody .= sprintf('<li>tags(%s): %s</li>', $language, $localized['tags']);
    $htmlBody .= sprintf('<li>thumbs(%s): %s</li>', $language, $localized['thumbnails']);
    $htmlBody .= '</ul>';
  }
}
/**
 * Returns a list of localized metadata for a video.
 *
 * @param Google_Service_YouTube $youtube YouTube service object.
 * @param string $videoId The videoId parameter instructs the API to return the
 * localized metadata for the video specified by the video id.
 * @param $htmlBody - html body.
 */
function listVideoLocalizations(Google_Service_YouTube $youtube, $videoId, &$htmlBody) {
  // Call the YouTube Data API's videos.list method to retrieve videos.
  $videos = $youtube->videos->listVideos("snippet,localizations", array(
      'id' => $videoId
  ));
  // If $videos is empty, the specified video was not found.
  if (empty($videos)) {
    $htmlBody .= sprintf('<h3>Can\'t find a video with video id: %s</h3>', $videoId);
  } else {
    // Since the request specified a video ID, the response only
    // contains one video resource.
    $localizations = $videos[0]["localizations"];
    $htmlBody .= "<h3>Video</h3><ul>";
    foreach ($localizations as $language => $localization) {
      $htmlBody .= sprintf('<li>title(%s): %s</li>', $language, $localization['title']);
      $htmlBody .= sprintf('<li>description(%s): %s</li>', $language, $localization['description']);      
    }
    $htmlBody .= '</ul>';
  }
}
?>

<!doctype html>
<html>
<head>
<title>Set and retrieve localized metadata for a video</title>
</head>
<body>
  <?=$htmlBody?>
</body>
</html>